package gov.va.med.mhv.getcare.model;

import java.io.Serializable;
import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

import gov.va.med.mhv.common.data.model.FacilityInfo;

@Entity
@Table(name = "PHR_WELLNESS_REMINDER")
public class WellnessReminder implements Serializable {

	private static final long serialVersionUID = -6712481532038732818L;

	@Id
	@Column(name = "PHR_WELLNESS_REMINDER_ID")
	@GeneratedValue(strategy = GenerationType.AUTO)
	private Long id;

	@Column(name = "OPLOCK")
	private Integer oplock;

	@Column(name = "STATION_NUMBER")
	private String stationNumber;

	@Column(name = "EXTRACT_DATE")
	@Temporal(TemporalType.TIMESTAMP)
	private Date extactDate;

	@Column(name = "DUE_DATE_PRECISE")
	private String dueDatePrecise;

	@Column(name = "DUE_DATE_IMPRECISE")
	private String dueDateImrecise;

	@Column(name = "DATE_LAST_DONE_PRECISE")
	private String dateLastDonePrecise;

	@Column(name = "DATE_LAST_DONE_IMPRECISE")
	private String dateLastDoneImprecise;

	@Column(name = "WELLNESS_STATUS")
	private String wellnessStatus;

	@Column(name = "SUBJECT")
	private String subject;

	@Column(name = "PATIENT_ID")
	private Long patientId;

	@Column(name = "FACILITY_INFO_ID", insertable = false, updatable = false)
	private Long facilityInfoId;

	@ManyToOne(fetch = FetchType.EAGER)
	@JoinColumn(name = "FACILITY_INFO_ID")
	private FacilityInfo facilityInfo;

	@Column(name = "PHR_FACILITY_CONTROL_ID")
	private Long phrFacilityControlId;

	@Lob
	@Column(name = "FULL_SUMMARY")
	private String fullSummary;

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public Integer getOplock() {
		return oplock;
	}

	public void setOplock(Integer oplock) {
		this.oplock = oplock;
	}

	public String getStationNumber() {
		return stationNumber;
	}

	public void setStationNumber(String stationNumber) {
		this.stationNumber = stationNumber;
	}

	public Date getExtactDate() {
		return extactDate;
	}

	public void setExtactDate(Date extactDate) {
		this.extactDate = extactDate;
	}

	public String getDueDatePrecise() {
		return dueDatePrecise;
	}

	public void setDueDatePrecise(String dueDatePrecise) {
		this.dueDatePrecise = dueDatePrecise;
	}

	public String getDueDateImrecise() {
		return dueDateImrecise;
	}

	public void setDueDateImrecise(String dueDateImrecise) {
		this.dueDateImrecise = dueDateImrecise;
	}

	public String getDateLastDonePrecise() {
		return dateLastDonePrecise;
	}

	public void setDateLastDonePrecise(String dateLastDonePrecise) {
		this.dateLastDonePrecise = dateLastDonePrecise;
	}

	public String getDateLastDoneImprecise() {
		return dateLastDoneImprecise;
	}

	public void setDateLastDoneImprecise(String dateLastDoneImprecise) {
		this.dateLastDoneImprecise = dateLastDoneImprecise;
	}

	public String getWellnessStatus() {
		return wellnessStatus;
	}

	public void setWellnessStatus(String wellnessStatus) {
		this.wellnessStatus = wellnessStatus;
	}

	public String getSubject() {
		return subject;
	}

	public void setSubject(String subject) {
		this.subject = subject;
	}

	public Long getPatientId() {
		return patientId;
	}

	public void setPatientId(Long patientId) {
		this.patientId = patientId;
	}

	public Long getFacilityInfoId() {
		return facilityInfoId;
	}

	public void setFacilityInfoId(Long facilityInfoId) {
		this.facilityInfoId = facilityInfoId;
	}

	public FacilityInfo getFacilityInfo() {
		return facilityInfo;
	}

	public void setFacilityInfo(FacilityInfo facilityInfo) {
		this.facilityInfo = facilityInfo;
	}

	public Long getPhrFacilityControlId() {
		return phrFacilityControlId;
	}

	public void setPhrFacilityControlId(Long phrFacilityControlId) {
		this.phrFacilityControlId = phrFacilityControlId;
	}

	public String getFullSummary() {
		return fullSummary;
	}

	public void setFullSummary(String fullSummary) {
		this.fullSummary = fullSummary;
	}
}
